/* Copyright (C) 2003 Vladimir Roubtsov. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * $Id: IProperties.java,v 1.1.1.1 2004/05/09 16:57:54 vlad_r Exp $
 */
package com.vladium.util;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

// ----------------------------------------------------------------------------
/**
 * @author Vlad Roubtsov, (C) 2003
 */
public
interface IProperties
{
    // public: ................................................................
    
    
    interface IMapper
    {
        String getMappedKey (final String key);
        
    } // end of nested interface
    
    
    String getProperty (String key);
    String getProperty (String key, String dflt);
    
    Iterator /* String */ properties ();
    boolean isEmpty ();
    void list (PrintWriter out);
    
    String setProperty (String key, String value);
    
    
    abstract class Factory
    {
        public static IProperties create (final IMapper mapper)
        {
            return new PropertiesImpl (null, mapper);
        }
        
        public static IProperties wrap (final Properties properties, final IMapper mapper)
        {
            final Map map = new HashMap ();
            
            // always use propertyNames() for traversing java.util.Properties:
            
            for (Enumeration names = properties.propertyNames (); names.hasMoreElements (); )
            {
                final String n = (String) names.nextElement ();
                final String v = properties.getProperty (n);
                
                map.put (n, v);
            }
            
            return new PropertiesImpl (map, mapper);// note: map is a defensive clone
        }
        
        public static IProperties combine (final IProperties overrides, final IProperties base)
        {
            if (overrides == null)
            {
                if (base == null)
                    return create (null);
                else
                    return base;
            }
            else if (base == null)
                return overrides;
            
            // [assertion: overrides != null && base != null]
            
            ((PropertiesImpl) overrides).getLastProperties ().setDelegate ((PropertiesImpl) base);
            
            return overrides;
        }
        
        /*
         * Not MT-safe
         */
        private static final class PropertiesImpl implements IProperties
        {
            // ACCESSORS (IProperties):
            
            public String getProperty (final String key)
            {
                return getProperty (key, null);
            }
            
            public String getProperty (final String key, final String dflt)
            {
                String value = (String) m_valueMap.get (key);
                
                // first, try to delegate horizontally:
                if ((value == null) && (m_mapper != null))
                {
                    final String mappedKey = m_mapper.getMappedKey (key);
                    
                    if (mappedKey != null)
                        value = (String) m_valueMap.get (mappedKey); 
                }
                
                // next, try to delegate vertically:
                if ((value == null) && (m_delegate != null))
                {
                    value = m_delegate.getProperty (key, null); 
                }
                
                return value != null ? value : dflt;
            }
            
            public Iterator /* String */ properties ()
            {
                return unmappedKeySet ().iterator ();
            }
            
            public boolean isEmpty ()
            {
                return m_valueMap.isEmpty () && ((m_delegate == null) || ((m_delegate != null) && m_delegate.isEmpty ()));
            }
            
            public void list (final PrintWriter out)
            {
                if (out != null)
                {
                    for (Iterator i = properties (); i.hasNext (); )
                    {
                        final String n = (String) i.next ();
                        final String v = getProperty (n);
                        
                        out.println (n + ":\t[" + v + "]");
                    }
                }
            }
            
            // MUTATORS:
            
            public String setProperty (final String key, final String value)
            {
                if (value == null)
                    throw new IllegalArgumentException ("null input: value");
                
                m_unmappedKeySet = null;
                
                return (String) m_valueMap.put (key, value); 
            }
            
            
            PropertiesImpl (final Map values, final IMapper mapper)
            {
                m_mapper = mapper;
                m_valueMap = values != null ? values : new HashMap ();
                
                m_delegate = null;
            }
            
            
            Set unmappedKeySet ()
            {
                Set result = m_unmappedKeySet;
                if (result == null)
                {
                    result = new TreeSet ();
                    result.addAll (m_valueMap.keySet ());
                    if (m_delegate != null)
                        result.addAll (m_delegate.unmappedKeySet ());
                    
                    m_unmappedKeySet = result;
                    return result;
                }
                
                return result;
            }
            
            // ACCESSORS:
            
            PropertiesImpl getLastProperties ()
            {
                PropertiesImpl result = this;
                
                for (PropertiesImpl delegate = m_delegate; delegate != null; delegate = delegate.m_delegate)
                {
                    // this does not detect all possible cycles:
                    if (delegate == this)
                        throw new IllegalStateException ("cyclic delegation detected");
                    
                    result = delegate;
                }
                
                return result;
            }
            
            // MUTATORS:
            
            void setDelegate (final PropertiesImpl delegate)
            {
                m_delegate = delegate;
                
                m_unmappedKeySet = null;
            }
            
            
            private final IMapper m_mapper;
            private final Map m_valueMap;
            
            private PropertiesImpl m_delegate;
            private transient Set m_unmappedKeySet;
            
        } // end of nested class
        
    } // end of nested class
    
    // protected: .............................................................

    // package: ...............................................................
    
    // private: ...............................................................

} // end of class
// ----------------------------------------------------------------------------