/* Copyright (C) 2003 Vladimir Roubtsov. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * $Id: LoggerInit.java,v 1.1.1.1 2004/05/09 16:57:51 vlad_r Exp $
 */
package com.vladium.logging;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
 
// ----------------------------------------------------------------------------
/**
 * TODO: polish the API and the overall cfg strategy here
 * 
 * @author Vlad Roubtsov, (C) 2003
 */
public
abstract class LoggerInit implements ILogLevels
{
    // public: ................................................................
    
    
    public static int stringToLevel (final String level)
    {
        // TODO: support level numbers as well
        
        if ("SEVERE".equalsIgnoreCase (level))
            return SEVERE;
        else if ("WARNING".equalsIgnoreCase (level))
            return WARNING;
        else if ("INFO".equalsIgnoreCase (level))
            return INFO;
        else if ("VERBOSE".equalsIgnoreCase (level))
            return VERBOSE;
        else if ("TRACE1".equalsIgnoreCase (level))
            return TRACE1;
        else if ("TRACE2".equalsIgnoreCase (level))
            return TRACE2;
        else if ("TRACE3".equalsIgnoreCase (level))
            return TRACE3;
        else if ("ALL".equalsIgnoreCase (level))
            return ALL;
        else
        {
            int _level = Integer.MIN_VALUE;
            try
            {
                _level = Integer.parseInt (level);
            }
            catch (Exception ignore) {};
            
            if ((_level >= NONE) && (_level <= ALL))
                return _level;
            else
                return NONE;
        }
    }
    
    public static synchronized void setLevel (final int level)
    {
        if ((level < NONE) || (level > ALL))
            throw new IllegalArgumentException ("invalid log level: " + level);
            
        s_level = level;
    }
    
    public static synchronized void setOut (final PrintWriter out)
    {
        if ((out == null) || out.checkError ())
            throw new IllegalArgumentException ("null or corrupt input: out");
        
        s_out = out;
    }

    public static synchronized void setPrefix (final String prefix)
    {
        s_prefix = prefix;
    }
    
    /**
     * note: the names are relative to Logger.PREFIX_TO_STRIP.
     */ 
    public static synchronized void setClassMask (final String [] names)
    {
        if ((names == null) || (names.length == 0))
            throw new IllegalArgumentException ("null or empty input: names");
            
        for (int n = 0; n < names.length; n ++)
        {
            if ((names [n] == null) || (names [n].length () == 0))
                throw new IllegalArgumentException ("null or empty input: names[" + n + "]");
        }
        
        
        final Set classMask = new HashSet ();
        for (int n = 0; n < names.length; n ++)
        {
            classMask.add (names [n]);
        }
        
        s_classMask = classMask;
    }
    
        
    // protected: .............................................................

    // package: ...............................................................
    
    
    static int s_level = INFO; // always in [NONE, ALL] range
    static PrintWriter s_out = new PrintWriter (System.out, false); // never null
    static String s_prefix = null; // null is equivalent to no prefix
    static Set s_classMask; // null is equivalent to not masking anything
    
    // private: ...............................................................
    
} // end of class
// ----------------------------------------------------------------------------
