/* Copyright (C) 2003 Vladimir Roubtsov. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * $Id: ILogLevels.java,v 1.1.1.1 2004/05/09 16:57:51 vlad_r Exp $
 */
package com.vladium.logging;

// ----------------------------------------------------------------------------
/**
 * An enumeration of log level values used in conjunction with the API in
 * {@link Logger} 
 * 
 * @see Logger
 * 
 * @author Vlad Roubtsov, (C) 2001
 */
public
interface ILogLevels
{
    // public: ................................................................
    
    // note: must start with 0
    
    /** log level excluding all but severe errors */
    static final int SEVERE         = 0;    // "-silent"
    /** log level for quieter than normal operation */
    static final int WARNING        = 1;    // "-quiet"
    /** default log level */
    static final int INFO           = 2;    // default
    /** log level for chattier than normal operation */
    static final int VERBOSE        = 3;    // "-verbose"
    
    // debug levels:
    
    /** debug trace log level */
    static final int TRACE1         = 4;
    /** finer debug trace log level */
    static final int TRACE2         = 5;
    /** finest debug trace log level */
    static final int TRACE3         = 6;
    
    // special constants:
    
    /** setting log level to NONE disables all logging */
    static final int NONE           = -1;
    /** setting log level to ALL enables all log levels */
    static final int ALL            = TRACE3 + 1;

} // end of class
// ----------------------------------------------------------------------------
