/* Copyright (C) 2003 Vladimir Roubtsov. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * $Id: RTExitHook.java,v 1.1.1.1 2004/05/09 16:57:44 vlad_r Exp $
 */
package com.vladium.emma.rt;

import java.io.File;

import com.vladium.emma.data.ICoverageData;

// ----------------------------------------------------------------------------
/**
 * @author Vlad Roubtsov, (C) 2003
 */
final class RTExitHook implements Runnable
{
    // public: ................................................................
    
    
    public synchronized void run ()
    {
        if (m_cdata != null)
        {
//            System.out.println ("HOOK DUMPING " + RTExitHook.class.getClassLoader ());
            
            RT.dumpCoverageData (m_cdata, true, m_outFile, m_merge);
            
            m_RT = null;
            m_cdata = null;
        }
    }
    
    // protected: .............................................................

    // package: ...............................................................


    RTExitHook (final Class RT, final ICoverageData cdata, final File outFile, final boolean merge)
    {
        m_RT = RT;
        m_cdata = cdata;
        
        m_outFile = outFile;
        m_merge = merge;
    }
        
    // private: ...............................................................


    private final File m_outFile;
    private final boolean m_merge;
    
    private Class m_RT;
    private ICoverageData m_cdata;
    
} // end of class
// ----------------------------------------------------------------------------