/* Copyright (C) 2003 Vladimir Roubtsov. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * $Id: CoverageOptions.java,v 1.1.1.1 2004/05/09 16:57:31 vlad_r Exp $
 */
package com.vladium.emma.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;

import com.vladium.util.IProperties;
import com.vladium.util.Property;
import com.vladium.emma.instr.InstrProcessor;

// ----------------------------------------------------------------------------
/**
 * @author Vlad Roubtsov, (C) 2003
 */
public
final class CoverageOptions implements Serializable
{
    // public: ................................................................
    
    
    public static CoverageOptions create (final Properties properties)
    {
        final boolean excludeSyntheticMethods = Property.toBoolean (properties.getProperty (InstrProcessor.PROPERTY_EXCLUDE_SYNTHETIC_METHODS,
                                                                                            InstrProcessor.DEFAULT_EXCLUDE_SYNTHETIC_METHODS));
                                                                        
        final boolean excludeBridgeMethods = Property.toBoolean (properties.getProperty (InstrProcessor.PROPERTY_EXCLUDE_BRIDGE_METHODS,
                                                                                         InstrProcessor.DEFAULT_EXCLUDE_BRIDGE_METHODS));
                                                                                            
        final boolean doSUIDCompensaton = Property.toBoolean (properties.getProperty (InstrProcessor.PROPERTY_DO_SUID_COMPENSATION,
                                                                                      InstrProcessor.DEFAULT_DO_SUID_COMPENSATION));
        
        return new CoverageOptions (excludeSyntheticMethods, excludeBridgeMethods, doSUIDCompensaton);
    }
    
    public static CoverageOptions create (final IProperties properties)
    {
        final boolean excludeSyntheticMethods = Property.toBoolean (properties.getProperty (InstrProcessor.PROPERTY_EXCLUDE_SYNTHETIC_METHODS,
                                                                                            InstrProcessor.DEFAULT_EXCLUDE_SYNTHETIC_METHODS));
        
        final boolean excludeBridgeMethods = Property.toBoolean (properties.getProperty (InstrProcessor.PROPERTY_EXCLUDE_BRIDGE_METHODS,
                                                                                         InstrProcessor.DEFAULT_EXCLUDE_BRIDGE_METHODS));
                                                                                         
        final boolean doSUIDCompensaton = Property.toBoolean (properties.getProperty (InstrProcessor.PROPERTY_DO_SUID_COMPENSATION,
                                                                                      InstrProcessor.DEFAULT_DO_SUID_COMPENSATION));
        
        return new CoverageOptions (excludeSyntheticMethods, excludeBridgeMethods, doSUIDCompensaton);
    }
    
    
    public boolean excludeSyntheticMethods ()
    {
        return m_excludeSyntheticMethods;
    }
    
    public boolean excludeBridgeMethods ()
    {
        return m_excludeBridgeMethods;
    }
    
    public boolean doSUIDCompensation ()
    {
        return m_doSUIDCompensation;
    }
    
    // protected: .............................................................

    // package: ...............................................................
    
    
    static CoverageOptions readExternal (final DataInput in)
        throws IOException
    {
        return new CoverageOptions (in.readBoolean (),
                                    in.readBoolean (),
                                    in.readBoolean ());
    }
    
    static void writeExternal (final CoverageOptions options, final DataOutput out)
        throws IOException
    {
        out.writeBoolean (options.m_excludeSyntheticMethods);
        out.writeBoolean (options.m_excludeBridgeMethods);
        out.writeBoolean (options.m_doSUIDCompensation);
    }
    
    // private: ...............................................................


    private CoverageOptions (final boolean excludeSyntheticMethods,
                             final boolean excludeBridgeMethods,
                             final boolean doSUIDCompensation)
    {
        m_excludeSyntheticMethods = excludeSyntheticMethods;
        m_excludeBridgeMethods = excludeBridgeMethods;
        m_doSUIDCompensation = doSUIDCompensation;
    }
    
    
    private final boolean m_excludeSyntheticMethods;
    private final boolean m_excludeBridgeMethods;
    private final boolean m_doSUIDCompensation;

} // end of class
// ----------------------------------------------------------------------------