/* Copyright (C) 2003 Vladimir Roubtsov. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * $Id: SuppressableTask.java,v 1.1.1.1 2004/05/09 16:57:27 vlad_r Exp $
 */
package com.vladium.emma.ant;

import com.vladium.emma.IAppConstants;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;

// ----------------------------------------------------------------------------
/**
 * @author Vlad Roubtsov, (C) 2003
 */
public
abstract class SuppressableTask extends Task
{
    // public: ................................................................
    
    
    /**
     * Set the optional 'enabled' attribute [defaults to 'true'].
     */
    public final void setEnabled (final boolean enabled)
    {
        m_enabled = enabled;
    }
    
    public final boolean isEnabled ()
    {
        return m_enabled;
    }
    
    public static BuildException newBuildException (final String msg, final Location location)
    {
        final String prefixedMsg = ((msg == null) || (msg.length () == 0))
            ? msg
            : IAppConstants.APP_THROWABLE_BUILD_ID + " " + msg;
       
        return new BuildException (prefixedMsg, location); 
    }
    
    public static BuildException newBuildException (final String msg, final Throwable cause, final Location location)
    {
        final String prefixedMsg = ((msg == null) || (msg.length () == 0))
            ? msg
            : IAppConstants.APP_THROWABLE_BUILD_ID + " " + msg;
       
        return new BuildException (prefixedMsg, cause, location); 
    }
    
    // protected: .............................................................
    
    
    protected SuppressableTask ()
    {
        m_enabled = true; // by default, all tasks are enabled
    }
    
    // package: ...............................................................

    // private: ...............................................................
    
    
    private boolean m_enabled;
    
} // end of class
// ----------------------------------------------------------------------------