/* Copyright (C) 2003 Vladimir Roubtsov. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * $Id: NestedTask.java,v 1.1.1.1 2004/05/09 16:57:27 vlad_r Exp $
 */
package com.vladium.emma.ant;

import java.io.File;
import java.util.Properties;

import org.apache.tools.ant.BuildException;

import com.vladium.util.Property;

// ----------------------------------------------------------------------------
/**
 * @author Vlad Roubtsov, (C) 2003
 */
public
abstract class NestedTask extends SuppressableTask
{
    // public: ................................................................
    
    
    public void init () throws BuildException
    {
        super.init ();
        
        m_genericCfg = new GenericCfg (this);
    }

    
    // .properties file attribute:
    
    public final void setProperties (final File file)
    {
        m_genericCfg.setProperties (file);
    }

    // generic property element:
    
    public final PropertyElement createProperty ()
    {
        return m_genericCfg.createProperty ();
    }
    
    // protected: .............................................................

    
    protected final Properties getTaskSettings ()
    {
        return Property.combine (getGenericSettings (), getFileSettings ());
    }    

    protected final Properties getFileSettings ()
    {
        return m_genericCfg.getFileSettings ();
    }
    
    protected final Properties getGenericSettings ()
    {
        return m_genericCfg.getGenericSettings ();
    }

    // package: ...............................................................
    
    // private: ...............................................................
    
    
    private /*final*/ GenericCfg m_genericCfg;

} // end of class
// ----------------------------------------------------------------------------