/* Copyright (C) 2003 Vladimir Roubtsov. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * $Id: GenericCfg.java,v 1.1.1.1 2004/05/09 16:57:27 vlad_r Exp $
 */
package com.vladium.emma.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import com.vladium.util.Property;
import com.vladium.util.XProperties;

// ----------------------------------------------------------------------------
/**
 * @author Vlad Roubtsov, (C) 2003
 */
public
class GenericCfg
{
    // public: ................................................................
    

    public GenericCfg (final Task task)
    {
        if (task == null) throw new IllegalArgumentException ("null input: task");
        
        m_task = task;
        m_genericPropertyElements = new ArrayList ();
    }
    

    // .properties file attribute:
    
    public void setProperties (final File file)
    {
        m_settingsFile = file; // actual file I/O is done in getFileSettings()
    }

    // generic property element:
    
    public PropertyElement createProperty ()
    {
        m_genericSettings = null;
        
        final PropertyElement property = new PropertyElement ();
        m_genericPropertyElements.add (property);
        
        return property;
    }

    // ACCESSORS:

    public Properties getFileSettings ()
    {
        Properties fileSettings = m_fileSettings;
        if ((fileSettings == null) && (m_settingsFile != null))
        {
            try
            {
                fileSettings = Property.getPropertiesFromFile (m_settingsFile);
                m_fileSettings = fileSettings;
            }
            catch (IOException ioe)
            {
                throw (BuildException) SuppressableTask.newBuildException (m_task.getTaskName ()
                    + ": property file [" + m_settingsFile.getAbsolutePath () + "] could not be read" , ioe, m_task.getLocation ()).fillInStackTrace ();
            }
        }
        
        return fileSettings;
    }
    
    public Properties getGenericSettings ()
    {
        Properties genericSettings = m_genericSettings;
        if (genericSettings == null)
        {
            genericSettings = new XProperties ();
            
            for (Iterator i = m_genericPropertyElements.iterator (); i.hasNext (); )
            {
                final PropertyElement property = (PropertyElement) i.next ();
                
                final String name = property.getName ();
                final String value = property.getValue () != null ? property.getValue () : "";
                
                if (name != null)
                    genericSettings.setProperty (name, value);
            }
            
            m_genericSettings = genericSettings;
        }
        
        return genericSettings;
    }
    
    // protected: .............................................................

    // package: ...............................................................
    
    // private: ...............................................................
    
    
    private final Task m_task;
        
    private final List /* PropertyElement */ m_genericPropertyElements; // never null
    private File m_settingsFile; // can be null
    
    private transient Properties m_fileSettings; // can be null
    private transient Properties m_genericSettings; // can be null

} // end of class
// ----------------------------------------------------------------------------